// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/osc_fixed.h $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: header file

#ifndef	__OSC_FIXED_H__
#define	__OSC_FIXED_H__

#include "main.h"



// data types *****************************************************************

typedef struct
{
	os_sem_t	sem;
	s32			freq_ref;

	struct
	{
		s32		freq_want;
		s32		freq_got;
	} chan[4];

} osc_fixed_t;



// prototypes *****************************************************************

void	osc_fixed_close(dev_data_t* dev, int index);
int		osc_fixed_info(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_fixed_init(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_fixed_measure(dev_data_t* dev, int index, sio4_osc_t* arg);
void	osc_fixed_open(dev_data_t* dev, int index);
int		osc_fixed_program(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_fixed_reference(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_fixed_reset(dev_data_t* dev, int index, sio4_osc_t* arg);
void	osc_fixed_startup(dev_data_t* dev);
int		osc_fixed_test(dev_data_t* dev, int index, sio4_osc_t* arg);



#endif
