// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/osc_cy22393_sio4.h $
// $Rev: 53095 $
// $Date: 2023-06-13 10:42:41 -0500 (Tue, 13 Jun 2023) $

// SIO4: Device Driver: header file

#ifndef	__OSC_CY22393_SIO4_H__
#define	__OSC_CY22393_SIO4_H__

#include "osc_cy22393.h"



// data types *****************************************************************


typedef struct
{
	os_sem_t		sem;		// One access at a time.
	osc_cy22393_t	osc;
	s32				ref_comp;	// Computed reference.
	s32				ref_meas;	// Measured reference.
	s32				ref_max;	// Maximum app request.
	s32				ref_min;	// Minimum app request.
	u32				pd_max;		// Max divider value for device.

	u8				_06;		// Must be cached.
	u8				_07;		// Must be cached.
	u8				_18;		// Must be cached.
	u8				_19;		// Must be cached.
	u8				_1a;		// Must be cached.
	u8				_1b;		// Must be cached.

	struct
	{
		u32			freq_want;
		u32			freq_got;
		u8			pd;			// Firmware Post Divider.
	} chan[4];

} osc_cy22393_sio4_t;



// prototypes *****************************************************************

void	osc_cy22393_sio4_close(dev_data_t* dev, int index);
int		osc_cy22393_sio4_info(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_cy22393_sio4_init(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_cy22393_sio4_measure(dev_data_t* dev, int index, sio4_osc_t* arg);
void	osc_cy22393_sio4_open(dev_data_t* dev, int index);
int		osc_cy22393_sio4_program(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_cy22393_sio4_reference(dev_data_t* dev, int index, sio4_osc_t* arg);
int		osc_cy22393_sio4_reset(dev_data_t* dev, int index, sio4_osc_t* arg);
void	osc_cy22393_sio4_startup(dev_data_t* dev);
int		osc_cy22393_sio4_test(dev_data_t* dev, int index, sio4_osc_t* arg);



#endif
