// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/mp_unknown.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	mp_unknown_close
*
*	Purpose:
*
*		Perform any work needed as the device is being closed.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_unknown_close(dev_data_t* dev, int index)
{
	sio4_mp_t	arg;

	mp_unknown_reset(dev, index, &arg);
}



/******************************************************************************
*
*	Function:	mp_unknown_config
*
*	Purpose:
*
*		Process an MP Protocol Configuration request.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_unknown_config(dev_data_t* dev, int index, sio4_mp_t* arg)
{
	arg->chip	= SIO4_MP_CHIP_UNKNOWN;

	switch (arg->prot_want)
	{
		default:

			arg->prot_got	= SIO4_MP_PROT_INVALID;
			break;

		case SIO4_MP_PROT_READ:

		// List ALL protocols defined by the interface.
		case SIO4_MP_PROT_DISABLE:
		case SIO4_MP_PROT_RS_232:
		case SIO4_MP_PROT_RS_422_485:
		case SIO4_MP_PROT_RS_423:

			arg->prot_got	= SIO4_MP_PROT_UNKNOWN;
			break;
	}

	return(0);
}



/******************************************************************************
*
*	Function:	mp_unknown_init
*
*	Purpose:
*
*		Process an MP Protocol Initialization request.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_unknown_init(dev_data_t* dev, int index, sio4_mp_t* arg)
{
	arg->chip	= SIO4_MP_CHIP_UNKNOWN;
	arg->prot_want	= SIO4_MP_PROT_UNKNOWN;
	arg->prot_got	= SIO4_MP_PROT_UNKNOWN;
	return(0);
}



/******************************************************************************
*
*	Function:	mp_unknown_open
*
*	Purpose:
*
*		Perform any work needed as the device is being opened.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_unknown_open(dev_data_t* dev, int index)
{
	sio4_mp_t	arg;

	mp_unknown_init(dev, index, &arg);
}



/******************************************************************************
*
*	Function:	mp_unknown_reset
*
*	Purpose:
*
*		Process an MP Protocol Reset request.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_unknown_reset(dev_data_t* dev, int index, sio4_mp_t* arg)
{
	arg->chip	= SIO4_MP_CHIP_UNKNOWN;
	arg->prot_want	= SIO4_MP_PROT_DISABLE;
	arg->prot_got	= SIO4_MP_PROT_UNKNOWN;
	return(0);
}



/******************************************************************************
*
*	Function:	mp_unknown_startup
*
*	Purpose:
*
*		Process an MP Startup request.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void mp_unknown_startup(dev_data_t* dev)
{
}



/******************************************************************************
*
*	Function:	mp_unknown_test
*
*	Purpose:
*
*		Process an MP Protocol Test request.
*
*	Arguments:
*
*		dev		The device structure to access.
*
*		index	The index of the channel to access.
*
*		arg		Data is exchanged with the caller here.
*
*	Returned:
*
*		0		Success.
*		< 0		An appropriate error status.
*
******************************************************************************/

int mp_unknown_test(dev_data_t* dev, int index, sio4_mp_t* arg)
{
	arg->chip	= SIO4_MP_CHIP_UNKNOWN;

	switch (arg->prot_want)
	{
		default:

			arg->prot_got	= SIO4_MP_PROT_INVALID;
			break;

		// List ALL protocols defined by the interface.
		case SIO4_MP_PROT_DISABLE:
		case SIO4_MP_PROT_RS_232:
		case SIO4_MP_PROT_RS_422_485:
		case SIO4_MP_PROT_RS_423:

			arg->prot_got	= SIO4_MP_PROT_UNKNOWN;
			break;
	}

	return(0);
}



