// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/isoch.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	isoch_tx_ioctl
*
*	Purpose:
*
*		Implement the Set Tx Isochronous Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 isoch_tx_ioctl(chan_data_t* chan, unsigned long arg)
{
	u8*						pu8Addr;
	u8						u8RegVal;
	XMT_ISOCHR_PROTOCOL*	pstrTxISOCHR	= (XMT_ISOCHR_PROTOCOL *) arg;
	s32						fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if (pstrTxISOCHR == ((XMT_ISOCHR_PROTOCOL *) NULL))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr = (u8*) chan->dev->vaddr.gsc_regs;
		u8RegVal = ISOCHR_MODE |
			((pstrTxISOCHR->u8TwoStopBits ? 1 : 0) << 6);

		os_reg_mem_tx_u8(chan->dev, (VADDR_T) (pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan)), u8RegVal);

		return(0);
	}
}



/******************************************************************************
*
*	Function:	isoch_rx_ioctl
*
*	Purpose:
*
*		Implement the Set Rx Isochronous Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 isoch_rx_ioctl(chan_data_t* chan, unsigned long arg)
{
	u8*	pu8Addr;
	s32	fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	pu8Addr = (u8*) chan->dev->vaddr.gsc_regs;

	os_reg_mem_tx_u8(chan->dev, (VADDR_T) (pu8Addr + ZILOG_CHAN_MODE_LOW_REG(chan)), ISOCHR_MODE);

	return(0);
}


