// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/hdlc.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	hdlc_tx_ioctl
*
*	Purpose:
*
*		Implement the Set Tx HDLC/SDLC Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 hdlc_tx_ioctl(chan_data_t* chan, void* arg)
{
	u8*					pu8Addr;
	u8					u8RegVal;
	XMT_HDLC_PROTOCOL*	pstrTxHDLC	= arg;
	s32					fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if ((pstrTxHDLC == NULL)					||
		(pstrTxHDLC->eTxUnderrun < ABORT_COND)	||
		(pstrTxHDLC->eTxUnderrun > CRC_FLAG_COND))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr		= chan->dev->vaddr.gsc_regs;
		u8RegVal	= 0;
		u8RegVal	|= HDLC_MODE;
		u8RegVal	|= (pstrTxHDLC->u8SharedZeroFlags ? 1 : 0)
					<< SHARED_ZERO_FLAGS_SHIFT;
		u8RegVal	|= (pstrTxHDLC->u8TxPreambleEnable ? 1 : 0)
					<< TX_PREAMBLE_ENABLE_SHIFT;
		u8RegVal	|= pstrTxHDLC->eTxUnderrun << TX_UNDERRUN_SHIFT;

		os_reg_mem_tx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan), u8RegVal);

		// u8RegVal = os_reg_mem_rx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan));

		return(0);
	}
}



/******************************************************************************
*
*	Function:	hdlc_rx_ioctl
*
*	Purpose:
*
*		Implement the Set Rx HDLC/SDLC Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 hdlc_rx_ioctl(chan_data_t* chan, void* arg)
{
	u8*					pu8Addr;
	RCV_HDLC_PROTOCOL*	pstrRxHDLC	= arg;
	u8					u8RegVal;
	s32					fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if ((pstrRxHDLC == NULL)							||
		(pstrRxHDLC->eAddrSearchMode < DISABLED)		||
		(pstrRxHDLC->eAddrSearchMode > EXT_PLUS_CTRL))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr		= chan->dev->vaddr.gsc_regs;
		u8RegVal	= 0;
		u8RegVal	|= HDLC_MODE;
		u8RegVal	|= (pstrRxHDLC->u816BitControlEnable ? 1 : 0)
					<< B16_CTRL_ENABLE_SHIFT;
		u8RegVal	|= (pstrRxHDLC->u8LogicalControlEnable ? 1 : 0)
					<< LOGICAL_CTRL_ENABLE_SHIFT;
		u8RegVal	|= pstrRxHDLC->eAddrSearchMode << ADDR_SEARCH_SHIFT;

		os_reg_mem_tx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_LOW_REG(chan), u8RegVal);
		return(0);
	}
}



/******************************************************************************
*
*	Function:	hdlc_loop_tx_ioctl
*
*	Purpose:
*
*		Implement the Set Tx HDLC/SDLC Loop Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 hdlc_loop_tx_ioctl(chan_data_t* chan, void* arg)
{
	u8*								pu8Addr;
	XMT_HDLC_SDLC_LOOP_PROTOCOL*	pHDLCLoop	= arg;
	u8								u8RegVal;
	s32								fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if ((pHDLCLoop == NULL)						||
		(pHDLCLoop->eTxUnderrun < ABORT_COND)	||
		(pHDLCLoop->eTxUnderrun > CRC_FLAG_COND))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr		= chan->dev->vaddr.gsc_regs;
		u8RegVal	= 0;
		u8RegVal	|= HDLC_LOOP_MODE;
		u8RegVal	|= (pHDLCLoop->u8SharedZeroFlags ? 1 : 0)
					<< SHARED_ZERO_FLAGS_SHIFT;
		u8RegVal	|= (pHDLCLoop->u8TxActiveOnPoll ? 1 : 0)
					<< TX_ACTIVE_ON_POLL_SHIFT;
		u8RegVal	|= pHDLCLoop->eTxUnderrun << TX_UNDERRUN_SHIFT;

		os_reg_mem_tx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan), u8RegVal);

		// u8RegVal = os_reg_mem_rx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan));

		return(0);

	}
}


