// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/feature.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	feature_test_ioctl
*
*	Purpose:
*
*		Implement the Feature Test IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the chanel being accessed.
*
*		arg		The argument passed by the user.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 feature_test_ioctl(chan_data_t* chan, void* arg)
{
	#define	_TEST_(v)						((v) ? SIO4_FEATURE_YES : SIO4_FEATURE_NO)

	dev_data_t*	dev	= chan->dev;
	s32*		val	= arg;

	switch (val[0])
	{
		default:

			val[0]	= SIO4_FEATURE_UNKNOWN;
			break;

		case SIO4_FEATURE_FW_TYPE_CONFIG:

			val[0]	= dev->cache.fw_type_config;
			break;

		case SIO4_FEATURE_RX_STATUS_WORD:

			val[0]	= chan->cache.rx_status_word;
			break;

		case SIO4_FEATURE_TIME_STAMP:

			val[0]	= dev->cache.time_stamp;
			break;

		case SIO4_FEATURE_LED_CHANNEL:

			val[0]	= dev->cache.led_channel;
			break;

		case SIO4_FEATURE_LED_MAIN:

			val[0]	= dev->cache.led_main;
			break;

		case SIO4_FEATURE_RX_FIFO_OVERRUN:

			val[0]	= chan->cache.rx_fifo_overrun;
			break;

		case SIO4_FEATURE_RX_FIFO_UNDERRUN:

			val[0]	= dev->cache.rx_fifo_underrun;
			break;

		case SIO4_FEATURE_TX_FIFO_EMPTY_CFG:

			val[0]	= chan->cache.tx_fifo_empty_cfg;
			break;

		case SIO4_FEATURE_TX_FIFO_OVERRUN:

			val[0]	= dev->cache.tx_fifo_overrun;
			break;

		case SIO4_FEATURE_FIFO_SPACE_CFG:

			val[0]	= dev->cache.fifo_space_cfg;
			break;

		case SIO4_FEATURE_INDEX_BOARD:

			val[0]	= dev->board_index;
			break;

		case SIO4_FEATURE_INDEX_DEVICE:

			val[0]	= chan->dev_index;
			break;

		case SIO4_FEATURE_MODEL_BASE:

			val[0]	= dev->cache.model;
			break;

		case SIO4_FEATURE_BOARD_RESET:

			val[0]	= _TEST_(dev->cache.board_reset);
			break;

		case SIO4_FEATURE_RX_FIFO_FULL_CFG:

			val[0]	= _TEST_(chan->cache.rx_fifo_full_cfg_chan);
			break;

		case SIO4_FEATURE_RX_FIFO_FULL_CFG_GLB:

			val[0]	= _TEST_(dev->cache.rx_fifo_full_cfg_glb);
			break;

		case SIO4_FEATURE_DMDMA_SCD:

			val[0]	= _TEST_(dev->cache.dmdma_scd);
			break;

		case SIO4_FEATURE_CHANNEL_QTY:

			val[0]	= dev->cache.channel_qty;
			break;

		case SIO4_FEATURE_DEVICE_QTY:

			val[0]	= dev->cache.device_qty;
			break;

		case SIO4_FEATURE_REG_BSR:

			val[0]	= _TEST_(dev->cache.reg_bsr);
			break;

		case SIO4_FEATURE_BUS_SPEED:

			val[0]	= dev->cache.bus_speed;
			break;

		case SIO4_FEATURE_BUS_WIDTH:

			val[0]	= dev->cache.bus_width;
			break;

		case SIO4_FEATURE_INDEX_CHANNEL:

			val[0]	= chan->index;
			break;

		case SIO4_FEATURE_FORM_FACTOR:

			val[0]	= dev->cache.form_factor;
			break;

		case SIO4_FEATURE_OSC_PD_MAX:

			val[0]	= dev->cache.osc_pd_max;
			break;

		case SIO4_FEATURE_COUNT:

			val[0]	= SIO4_FEATURE_LAST_INDEX + 1;
			break;

		case SIO4_FEATURE_REG_FCR:

			val[0]	= _TEST_(dev->cache.reg_fcr);
			break;

		case SIO4_FEATURE_REG_FSR:

			val[0]	= _TEST_(dev->cache.reg_fsr);
			break;

		case SIO4_FEATURE_FIFO_SIZE_RX:

			val[0]	= chan->cache.fifo_size_rx;
			break;

		case SIO4_FEATURE_FIFO_SIZE_TOTAL:

			val[0]	= dev->cache.fifo_size_total;
			break;

		case SIO4_FEATURE_FIFO_SIZE_TX:

			val[0]	= chan->cache.fifo_size_tx;
			break;

		case SIO4_FEATURE_REG_FR:

			val[0]	= _TEST_(dev->cache.reg_fr);
			break;

		case SIO4_FEATURE_FW_TYPE:

			val[0]	= dev->cache.fw_type;
			break;

		case SIO4_FEATURE_INDEX_SUBDEVICE:

			val[0]	= dev->cache.index_subdevice;
			break;

		case SIO4_FEATURE_IRQ_32:

			val[0]	= _TEST_(dev->cache.irq_32);
			break;

		case SIO4_FEATURE_LEGACY_CABLE:

			val[0]	= _TEST_(dev->cache.legacy_cable);
			break;

		case SIO4_FEATURE_MP:

			val[0]	= _TEST_(chan->cache.mp);
			break;

		case SIO4_FEATURE_MP_BITMAP:

			val[0]	= chan->cache.mp_bitmap;
			break;

		case SIO4_FEATURE_MP_CHIP:

			val[0]	= dev->cache.mp_chip;
			break;

		case SIO4_FEATURE_MP_PROGRAM:

			val[0]	= chan->cache.mp_program;
			break;

		case SIO4_FEATURE_OSC_CHIP:

			val[0]	= dev->cache.osc_chip;
			break;

		case SIO4_FEATURE_OSC_MEASURE:

			val[0]	= dev->cache.osc_measure;
			break;

		case SIO4_FEATURE_OSC_PER_CHANNEL:

			val[0]	= dev->cache.osc_per_chan;
			break;

		case SIO4_FEATURE_OSC_PROGRAM:

			val[0]	= dev->cache.osc_program;
			break;

		case SIO4_FEATURE_REG_PORD2R:

			val[0]	= _TEST_(dev->cache.reg_pord2r);
			break;

		case SIO4_FEATURE_REG_PSRCR:

			val[0]	= _TEST_(chan->cache.reg_psrcr);
			break;

		case SIO4_FEATURE_REG_PSTSR:

			val[0]	= _TEST_(chan->cache.reg_pstsr);
			break;

		case SIO4_FEATURE_REG_CCR:

			val[0]	= _TEST_(chan->cache.reg_ccr);
			break;

		case SIO4_FEATURE_REG_FTR:

			val[0]	= _TEST_(dev->cache.reg_ftr);
			break;

		case SIO4_FEATURE_REG_GPIOSR:

			val[0]	= _TEST_(chan->cache.reg_gpiosr);
			break;

		case SIO4_FEATURE_REG_IELR:

			val[0]	= _TEST_(dev->cache.reg_ielr);
			break;

		case SIO4_FEATURE_REG_IOCR:

			val[0]	= _TEST_(dev->cache.reg_iocr);
			break;

		case SIO4_FEATURE_REG_IHLR:

			val[0]	= _TEST_(dev->cache.reg_ihlr);
			break;

		case SIO4_FEATURE_REG_PCR:

			val[0]	= _TEST_(dev->cache.reg_pcr);
			break;

		case SIO4_FEATURE_REG_POCSR:

			val[0]	= _TEST_(dev->cache.reg_pocsr);
			break;

		case SIO4_FEATURE_REG_PORAR:

			val[0]	= _TEST_(dev->cache.reg_porar);
			break;

		case SIO4_FEATURE_REG_PORDR:

			val[0]	= _TEST_(dev->cache.reg_pordr);
			break;

		case SIO4_FEATURE_REG_PSRCR_BITS:

			val[0]	= chan->cache.reg_psrcr_bits;
			break;

		case SIO4_FEATURE_REG_PSTSR_BITS:

			val[0]	= chan->cache.reg_pstsr_bits;
			break;

		case SIO4_FEATURE_REG_RCR:

			val[0]	= _TEST_(chan->cache.reg_rcr);
			break;

		case SIO4_FEATURE_REG_SBR:

			val[0]	= _TEST_(chan->cache.reg_sbr);
			break;

		case SIO4_FEATURE_REG_TCR:

			val[0]	= _TEST_(chan->cache.reg_tcr);
			break;

		case SIO4_FEATURE_REG_TSR:

			val[0]	= _TEST_(dev->cache.reg_tsr);
			break;

		case SIO4_FEATURE_SIO4_TYPE:

			val[0]	= dev->cache.sio4_type;
			break;

		case SIO4_FEATURE_MODEL_SYNC:

			val[0]	= dev->cache.model_sync;
			break;

		case SIO4_FEATURE_USER_JUMPER_QTY:

			val[0]	= dev->cache.user_jumper_qty;
			break;

		case SIO4_FEATURE_USER_JUMPER_SENSE:

			val[0]	= dev->cache.user_jumper_sense;
			break;

		case SIO4_FEATURE_USER_JUMPER_VAL:

			val[0]	= dev->cache.user_jumper_val;
			break;

		case SIO4_FEATURE_MODEL_Z16C30:

			val[0]	= dev->cache.model_z16c30;
			break;
	}

	return(0);
}


