// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/driver/async.c $
// $Rev: 48525 $
// $Date: 2020-11-23 18:29:37 -0600 (Mon, 23 Nov 2020) $

// SIO4: Device Driver: source file

#include "main.h"



/******************************************************************************
*
*	Function:	async_tx_ioctl
*
*	Purpose:
*
*		Implement the Set Tx Asynchronous Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 async_tx_ioctl(chan_data_t* chan, void* arg)
{
	u8*					pu8Addr;
	XMT_ASYNC_PROTOCOL*	pstrTxASYNC	= arg;
	u8					u8RegVal;
	s32					fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if ((pstrTxASYNC == NULL)							||
		(pstrTxASYNC->eTxClockRate < RATE_X16)			||
		(pstrTxASYNC->eTxClockRate> LOCK_RATE)			||
		(pstrTxASYNC->eTxStopBits < ONE_STOP_BIT)		||
		(pstrTxASYNC->eTxStopBits > TWO_STOP_BITS_SHAVED))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr	= chan->dev->vaddr.gsc_regs;

		u8RegVal	= 0;
		u8RegVal	|= ASYNC_MODE;
		u8RegVal	|= pstrTxASYNC->eTxClockRate << CLOCK_RATE_SHIFT;
		u8RegVal	|= pstrTxASYNC->eTxStopBits << STOP_BITS_SHIFT;

		os_reg_mem_tx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan), u8RegVal);

		// u8RegVal = os_reg_mem_rx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_HIGH_REG(chan));

		return(0);
	}
}



/******************************************************************************
*
*	Function:	async_rx_ioctl
*
*	Purpose:
*
*		Implement the Set Rx Asynchronous Protocol IOCTL service.
*
*	Arguments:
*
*		chan	The structure for the channel to access.
*
*		arg		The argument passed by the application.
*
*	Returned:
*
*		0		All went well.
*		< 0		An appropriate error status.
*
******************************************************************************/

s32 async_rx_ioctl(chan_data_t* chan, void* arg)
{
	u8*					pu8Addr;
	RCV_ASYNC_PROTOCOL*	pstrRxASYNC	= arg;
	u8					u8RegVal;
	s32					fw_type;

	fw_type_config_get(chan, &fw_type);

	if (fw_type != SIO4_FW_TYPE_CONFIG_Z16C30)
		return(0);

	// check parameters
	if ((pstrRxASYNC == NULL)					||
		(pstrRxASYNC->eRxClockRate < RATE_X16)	||
		(pstrRxASYNC->eRxClockRate > LOCK_RATE))
	{
		return(-EINVAL);
	}
	else
	{
		pu8Addr = chan->dev->vaddr.gsc_regs;

		u8RegVal	= 0;
		u8RegVal	|= ASYNC_MODE;
		u8RegVal	|= pstrRxASYNC->eRxClockRate << CLOCK_RATE_SHIFT;

		os_reg_mem_tx_u8(chan->dev, pu8Addr + ZILOG_CHAN_MODE_LOW_REG(chan), u8RegVal);
		return(0);
	}
}


