#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_tx_cable_clock_config(
	int		fd,
	s32		set,
	s32*	get,
	int		verbose)
{
	int	status;

	status	= ioctl(fd, SIO4_TX_CABLE_CLOCK_CONFIG, &set);

	if (get)
		get[0]	= set;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
