#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_reg_read_raw(int fd, u32 index, u32* value)
{
	REGISTER_PARAMS	parm;
	int				status;

	parm.u32RegisterNumber	= index;
	parm.u32Value			= 0xDEADBEEF;
	status		= ioctl(fd, SIO4_READ_REGISTER_RAW, &parm);
	value[0]	= parm.u32Value;

	if (status == -1)
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
