#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_reg_mod(int fd, u32 reg, u32 value, u32 mask)
{
	REGISTER_MOD_PARAMS	parm;
	int					status;

	parm.u32RegisterNumber	= reg;
	parm.u32Value			= value;
	parm.u32Mask			= mask;
	status	= ioctl(fd, SIO4_MOD_REGISTER, &parm);

	if (status == -1)
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
