#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_osc_test(int fd, s32 want, s32* got, int verbose)
{
	sio4_osc_t	osc;
	int			status;

	osc.freq_want	= want;
	status			= ioctl(fd, SIO4_OSC_TEST, &osc);
	got[0]			= osc.freq_got;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
