#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_osc_reference(int fd, s32* freq_ref, int verbose)
{
	sio4_osc_t	osc;
	int			status;

	osc.freq_ref	= freq_ref[0];
	status			= ioctl(fd, SIO4_OSC_REFERENCE, &osc);
	freq_ref[0]		= osc.freq_ref;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
