#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_osc_info(
	int		fd,
	u32*	chip,
	s32*	freq_ref,
	s32*	freq_want,
	s32*	freq_got,
	int		verbose)
{
	sio4_osc_t	osc;
	int			status;

	status	= ioctl(fd, SIO4_OSC_INFO, &osc);

	if (chip)
		chip[0]			= osc.chip;

	if (freq_ref)
		freq_ref[0]		= osc.freq_ref;

	if (freq_want)
		freq_want[0]	= osc.freq_want;

	if (freq_got)
		freq_got[0]		= osc.freq_got;

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
