#include <errno.h>
#include <stdio.h>

#include "sio4_dsl.h"

int sio4_open(int device, int* fd)
{
	int		errs	= 0;
	char	name[128];
	int		ret;

	sprintf(name, "/dev/sio4%d", device);
	ret	= open(name, O_RDWR);

	if (ret < 0)
	{
		printf("ERROR: open() returned %d\n", ret);
		errs	= 1;
	}

	if (fd)
		fd[0]	= ret;

	return(errs);
}