#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_isochr_setup_tx(int fd, u8 two_stop_bits, int verbose)
{
	XMT_ISOCHR_PROTOCOL	parm;
	int					status;

	parm.u8TwoStopBits	= two_stop_bits;
	status	= ioctl(fd, SIO4_SET_XMT_ISOCHR_PROT, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
