#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_int_read_status(
	int						fd,
	SIO4_INTERRUPT_STATUS*	int_stat,
	int						verbose)
{
	int	status;

	status	= ioctl(fd, SIO4_READ_INT_STATUS, int_stat);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
