#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_hdlc_setup_rx(int fd, int verbose)
{
	RCV_HDLC_PROTOCOL	parm;
	int					status;

	parm.eAddrSearchMode		= ONE_BYTE_NO_CTRL;
	parm.u816BitControlEnable	= 1;
	parm.u8LogicalControlEnable	= 0;
	status	= ioctl(fd, SIO4_SET_RCV_HDLC_PROT, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
