#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_hdlc_sdlc_loop_setup_rx(int fd, int verbose)
{
	XMT_HDLC_SDLC_LOOP_PROTOCOL	parm;
	int							status;

	parm.u8SharedZeroFlags	= 1;
	parm.u8TxActiveOnPoll	= 0;
	parm.eTxUnderrun		= ABORT_COND;
	status	= ioctl(fd, SIO4_SET_XMT_HDLC_SDLC_LOOP_PROT, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
