#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_channel_init(int fd, int verbose)
{
	SIO4_INIT_CHAN	init;
	int				status;

	init.eMode					= INT_LOCAL_LOOPBACK;
	init.u32BaudRate			= 1228800L;
	init.eRxEnable				= ENABLE_WO_AUTO;
	init.eRxDataFormat			= NRZ;
	init.eRxDataLength			= BITS8;
	init.u8RxParityEnable		= 0;
	init.eRxParityType			= EVEN_PARITY;
	init.eTxEnable				= ENABLE_WO_AUTO;
	init.eTxDataFormat			= NRZ;
	init.eTxDataLength			= BITS8;
	init.u8TxParityEnable		= 0;
	init.eTxParityType			= EVEN_PARITY;
	init.eTxIdleLineCond		= SYNC_FLAG_NORMAL_IDLE;
	init.u8TxWaitOnUnderrun		= 0;
	init.u8EnableRxUpper		= 1;
	init.u8EnableRxLower		= 0;
	init.u8EnableTxUpper		= 0;
	init.u8EnableTxLower		= 1;
	init.u16TxAlmostEmpty		= 1;
	init.u16TxAlmostFull		= 1;
	init.u16RxAlmostEmpty		= 1;
	init.u16RxAlmostFull		= 1;
	init.u8EnableTxCableUpper	= 0;
	init.u8EnableTxCableLower	= 1;
	init.u8EnableRxCableUpper	= 1;
	init.u8EnableRxCableLower	= 0;

	status	= ioctl(fd, SIO4_INIT_CHANNEL, &init);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
