#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_channel_command_send(
	int				fd,
	SIO4_CHAN_CMD	command,
	int				verbose)
{
	int	status;

	status	= ioctl(fd, SIO4_SEND_CHANNEL_COMMAND, command);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
