#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

int sio4_async_setup_tx(
	int			fd,
	CLOCK_RATE	rate,
	STOP_BITS	bits,
	int			verbose)
{
	XMT_ASYNC_PROTOCOL	parm;
	int					status;

	parm.eTxClockRate	= rate;
	parm.eTxStopBits	= bits;
	status	= ioctl(fd, SIO4_SET_XMT_ASYNC_PROT, &parm);

	if ((verbose) && (status == -1))
		printf("ioctl() failure, errno = %d\n", errno);

	return(status);
}
