#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_dsl.h"

static int	_fd;

static void handle_sigio(int signo)
{
	SIO4_INTERRUPT_STATUS	int_stat;
	int						status;

	status	= ioctl(_fd, SIO4_READ_INT_STATUS, &int_stat);

	if (status == -1)
	{
		// The request failed.
	}
	else if (int_stat.u8SIO4Status & SIO4_INT_NOTIFY_TX_FIFO_AE)
	{
		// Handle the Tx FIFO Almost Empty condition.
	}
}

int sio4_async_setup(int fd)
{
	int				flags;
	unsigned char	notify;
	pid_t			pid;
	int				status;

	ioctl(fd, SIO4_INT_NOTIFY, 0);
	_fd	= fd;
	signal(SIGIO, handle_sigio);
	pid	= getpid();
	fcntl(fd, F_SETOWN, pid);
	flags	= fcntl(fd, F_GETFL);
	flags	|= FASYNC;
	fcntl(fd, F_SETFL, flags);
	notify	= SIO4_INT_NOTIFY_TX_FIFO_AE;
	status	= ioctl(fd, SIO4_INT_NOTIFY, notify);
	return(status);
}
