// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_1.x.x_GSC_DN/async/samples/rxasync/main.h $
// $Rev: 53083 $
// $Date: 2023-06-13 10:11:04 -0500 (Tue, 13 Jun 2023) $

// SIO4: Asynchronous Protocol Library: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <errno.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "sio4_main.h"



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	s32	mp;				// MP transceiver selection
	s32	pc;				// use a PC style configuration
	s32	print;
	int	qty;			// Number of devices detected.
	s32	seconds;		// transfer data for this long
	int	skip;			// skip testing?
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

	s32	baud;			// data transfer bit rate

} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args, int* skip);



#endif
