typedef unsigned char  U8;

typedef unsigned short U16;
typedef unsigned long  U32;
typedef double         U64;

// Barry's Windows Programming Tools
void CursorVisible(BOOL CVState);
void PositionCursor(U16 X, U16 Y);
void ClrScr(void);
void kbflush(void);
char wait_for_key(void);
char prompt_for_key(char *message);
char anykey(void);
void print_time(void);
void save_cursor(void);
void restore_cursor(void);
void Busy_Signal(int speed);
BOOL VersionDetect(void);
void SetColors(U16 ConsoleColor);
char dsp_time_scan_for_key(void);
void print_passed(void);
void print_failed(void);
void ShowAPIError(U32 APIReturnCode);

/******************************************
*             Definitions
******************************************/

#define API_RETURN_CODE_STARTS              0x201   // 513 Starting return code


// API Return Code Values
typedef enum _RETURN_CODE
{
    ApiFailed = API_RETURN_CODE_STARTS,
    ApiAccessDenied,
    ApiDmaChannelUnavailable,
    ApiDmaChannelInvalid,
    ApiDmaChannelTypeError,
    ApiDmaInProgress,
    ApiDmaDone,
    ApiDmaPaused,
    ApiDmaNotPaused,
    ApiDmaCommandInvalid,
    ApiDmaManReady,
    ApiDmaManNotReady,
    ApiDmaInvalidChannelPriority,			// 525
    ApiDmaManCorrupted,
    ApiDmaInvalidElementIndex,
    ApiDmaNoMoreElements,
    ApiDmaSglInvalid,
    ApiDmaSglQueueFull,
    ApiNullParam,
    ApiInvalidBusIndex,
    ApiUnsupportedFunction,
    ApiInvalidPciSpace,
    ApiInvalidIopSpace,						// 535
    ApiInvalidSize,
    ApiInvalidAddress,
    ApiInvalidAccessType,
    ApiInvalidIndex,
    ApiMuNotReady,
    ApiMuFifoEmpty,
    ApiMuFifoFull,
    ApiInvalidRegister,
    ApiDoorbellClearFailed,
    ApiInvalidUserPin,						// 545
    ApiInvalidUserState,
    ApiEepromNotPresent,
    ApiEepromTypeNotSupported,
    ApiEepromBlank,
    ApiConfigAccessFailed,
    ApiInvalidDeviceInfo,
    ApiNoActiveDriver,
    ApiInsufficientResources,
    ApiObjectAlreadyAllocated,
    ApiAlreadyInitialized,					// 555
    ApiNotInitialized,
    ApiBadConfigRegEndianMode,
    ApiInvalidPowerState,
    ApiPowerDown,
    ApiFlybyNotSupported,
    ApiNotSupportThisChannel,
    ApiNoAction,
    ApiHSNotSupported,
    ApiVPDNotSupported,
    ApiVpdNotEnabled,						// 565
    ApiNoMoreCap,
    ApiInvalidOffset,
    ApiBadPinDirection,
    ApiPciTimeout,
    ApiDmaChannelClosed,
    ApiDmaChannelError,
    ApiInvalidHandle,
    ApiBufferNotReady,
    ApiInvalidData,
    ApiDoNothing,							// 575
    ApiDmaSglBuildFailed,
    ApiPMNotSupported,
    ApiInvalidDriverVersion,
	ApiInvalidBoardNumber,
	ApiInvalidDMANumWords,
	ApiDMABufferTooSmall,
	ApiInvalidDMABufferAddr,
	ApiInvalidFWRev,
	ApiInvalidChannel,
    ApiLastError               // Do not add API errors below this line
} RETURN_CODE, *PRETURN_CODE;

