// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/utils/util_reg_read.c $
// $Rev: 46068 $
// $Date: 2019-08-13 15:38:23 -0500 (Tue, 13 Aug 2019) $

// PEX8112: Utilities: source file

#include "main.h"



/*******************************************************************************
*
*	Function:	pex8112_reg_read
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8112_IOCTL_REG_READ service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		The register to access.
*
*		get		The value read goes here.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*******************************************************************************/

int pex8112_reg_read(int fd, int index, int verbose, u32 reg, u32* get)
{
	gsc_reg_t	arg;
	int			errs	= 0;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Read", index);

	arg.reg		= reg;
	arg.value	= 0xDEADBEEF;
	arg.mask	= 0;	// unused here
	ret			= pex8112_ioctl(fd, PEX8112_IOCTL_REG_READ, &arg);
	errs		+= ret ? 1 : 0;

	if (verbose)
	{
		name	= gsc_reg_pex8112_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	if (get)
		get[0]	= arg.value;

	return(errs);
}


