// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/utils/util_reg_mod.c $
// $Rev: 46068 $
// $Date: 2019-08-13 15:38:23 -0500 (Tue, 13 Aug 2019) $

// PEX8112: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8112_reg_mod
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8112_IOCTL_REG_MOD service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		This is the register to access.
*
*		set		This is the value to apply via the mask.
*
*		mask	These are the bits to modify.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8112_reg_mod(int fd, int index, int verbose, u32 reg, u32 set, u32 mask)
{
	gsc_reg_t	arg;
	int			errs	= 0;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Mod", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= mask;
	ret			= pex8112_ioctl(fd, PEX8112_IOCTL_REG_MOD, &arg);
	errs		+= ret ? 1 : 0;

	if (verbose)
	{
		name	= gsc_reg_pex8112_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


