// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/utils/util_id.c $
// $Rev: 51725 $
// $Date: 2022-10-11 06:41:15 -0500 (Tue, 11 Oct 2022) $

// PEX8112: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		The handle used to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs	= 0;
	u32	reg;

	gsc_label("Vendor ID");
	errs	+= pex8112_reg_read(fd, -1, 0, GSC_PCI_8112_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= pex8112_reg_read(fd, -1, 0, GSC_PCI_8112_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x8112)
	{
		printf("(PEX8112)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	pex8112_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int pex8112_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs;
	const char*	psz			= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	= pex8112_query(fd, -1, 0, PEX8112_QUERY_DEVICE_TYPE, &device_type);

	if (errs)
	{
		if (verbose)
			printf("FAIL <---  (query error)\n");
	}
	else
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_PEX8112:	psz	= "PEX8112";	break;
		}

		if ((verbose) && (errs == 0))
			printf("%s\n", psz);

		gsc_label_level_inc();

		errs	+= _id_device_pci(fd);

		gsc_label_level_dec();
	}

	return(errs);
}



