// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/samples/regs/perform.c $
// $Rev: 51724 $
// $Date: 2022-10-10 17:45:06 -0500 (Mon, 10 Oct 2022) $

// PEX8112: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _dump_everything(int fd)
{
	os_id_host();
	printf("\n");
	os_id_driver(pex8112_open, pex8112_read, pex8112_close);
	printf("\n");
	pex8112_id_device(fd, -1, 1);
	printf("\n");
	gsc_reg_pex8112_list_pci(fd, pex8112_reg_read);
	printf("\n");
	gsc_reg_pex8112_list_plx(fd, pex8112_reg_read);
}



//*****************************************************************************
static void _dump_pci(int fd)
{
	gsc_reg_pex8112_list_pci(fd, pex8112_reg_read);
}



//*****************************************************************************
static void _dump_plx(int fd)
{
	gsc_reg_pex8112_list_plx(fd, pex8112_reg_read);
}



//*****************************************************************************
static void _id_device(int fd)
{
	pex8112_id_device(fd, -1, 1);
}



//*****************************************************************************
static void _id_driver(int fd)
{
	os_id_driver(pex8112_open, pex8112_read, pex8112_close);
}



//*****************************************************************************
static void _id_host(int fd)
{
	os_id_host();
}



//****************************************************************************
int perform_tests(int fd)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Device Identification",			_id_device			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(fd, &menu);
	return(0);
}



