// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/include/pex8112_utils.h $
// $Rev: 51722 $
// $Date: 2022-10-10 17:44:17 -0500 (Mon, 10 Oct 2022) $

// PEX8112: Utilities: header file

#ifndef	__PEX8112_UTILS_H__
#define	__PEX8112_UTILS_H__

#include "pex8112_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	pex8112_close_util		(int fd, int index, int verbose);
int	pex8112_init_util		(int verbose);
int	pex8112_ioctl_util		(int fd, int index, int verbose, int request, void* arg);
int	pex8112_open_util		(int device, int share, int index, int verbose, int* fd);
int pex8112_read_util		(int fd, int index, int verbose, void* dst, size_t bytes);

// IOCTL utility services

int	pex8112_query			(int fd, int index, int verbose, s32 set, s32* get);			// PEX8112_IOCTL_QUERY
int pex8112_reg_mod			(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// PEX8112_IOCTL_REG_MOD
int	pex8112_reg_read		(int fd, int index, int verbose, u32 reg, u32* value);			// PEX8112_IOCTL_REG_READ
int	pex8112_reg_write		(int fd, int index, int verbose, u32 reg, u32 value);			// PEX8112_IOCTL_REG_WRITE

// Auxiliary utility services

int pex8112_id_device		(int fd, int index, int verbose);

int	pex8112_count_boards	(int verbose, s32* get);



#endif
