// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/driver/pex8112.h $
// $Rev: 51727 $
// $Date: 2022-10-11 06:46:09 -0500 (Tue, 11 Oct 2022) $

// PEX8112: Device Driver: header file

#ifndef	__PEX8112_H__
#define	__PEX8112_H__

#include "gsc_common.h"
#include "gsc_pex8112.h"



// macros *********************************************************************

#define	PEX8112_BASE_NAME					"pex8112"

// IOCTL command codes
#define	PEX8112_IOCTL_REG_READ				OS_IOCTL_RW(0, 12, gsc_reg_t)
#define	PEX8112_IOCTL_REG_WRITE				OS_IOCTL_W (1, 12, gsc_reg_t)
#define	PEX8112_IOCTL_REG_MOD				OS_IOCTL_W (2, 12, gsc_reg_t)
#define	PEX8112_IOCTL_QUERY					OS_IOCTL_RW(3,  4, s32)



//*****************************************************************************
// PEX8112_IOCTL_REG_READ
// PEX8112_IOCTL_REG_WRITE
// PEX8112_IOCTL_REG_MOD
//
// Parameter:	gsc_reg_t*

//*****************************************************************************
// PEX8112_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	PEX8112_QUERY_COUNT,					// How many query options are supported?
	PEX8112_QUERY_DEVICE_TYPE,				// Value from gsc_dev_type_t

	PEX8112_IOCTL_QUERY_LAST

} pex8112_query_t;

#define	PEX8112_IOCTL_QUERY_ERROR			(-1)



#endif
