// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/driver/main.h $
// $Rev: 51727 $
// $Date: 2022-10-11 06:46:09 -0500 (Tue, 11 Oct 2022) $

// PEX8112: Device Driver: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include "pex8112.h"

#define	DEV_BAR_SHOW						0
#define	DEV_PCI_ID_SHOW						0
#define	GSC_ALT_DEV_GET(a)					(a)
#define	GSC_ALT_STRUCT_GET(i,d)				(d)
#define	GSC_ALT_STRUCT_T					dev_data_t
#define	GSC_DEVS_PER_BOARD					1
typedef struct _dev_data_t					dev_data_t;

#include "gsc_main.h"



// macros *********************************************************************

#define	DEV_MODEL							"PEX8112"	// Upper case form of the below.
#define	DEV_NAME							"pex8112"	// MUST AGREE WITH PEX8112_BASE_NAME

#define	DEV_VERSION							"2.3"		// FOR DEVICE SPECIFIC CODE ONLY!
// 2.3	Updated comments for consistency.
//		Removed unused macro.
//		Updated per changes to the directory structure and code reorganization.
//		White space cleanup.
// 2.2	Added support for the 5.x kernel series.
//		Added Endianness support.
//		Updated initial file content for consistency.
//		White space cleanup.
//		Removed an unused source file.
//		Corrected some comments.
//		Changed some variable names for clarity and consistency.
//		Updated per changes to the low level register interface.
//		Updated per changes to the OS specific PCI services.
//		Made updates for DEV_SUPPORTS_XXX macro changes.
// 2.1	Made PCI registers accessible from inside an ISR.
//		The BAR code has been updated to include the data under a single structure.
//		The register definitions have been updated.
//		I/O services now pass around an os_mem_t structure instead of a buffer pointer.
//		White space cleanup.
//		Changed the arbitrary wait event callback argument to a void* type.
//		Corrected the IOCTL code for the register write and mod services.
//		Modified to allow multiple apps to simultaneously access a single device.
// 2.0	Updated to use the newer common driver sources.
//		Removed GNU notice from non-Linux specific files.
//		Removed Linux specific content from non-Linux specific source files.
//		White space cleanup.
//		Now using a spinlock rather than enabling and disabling interrupts.
// 1.2	Reduced #include list in driver interface header.
// 1.1	Updated for the 3.x kernel.
// 1.0	Initial release.

#define	GSC_PCI_SPACE_SIZE					0xFFF



// data types *****************************************************************

struct _dev_data_t
{
	os_pci_t			pci;			// The kernel PCI device descriptor.
	os_data_t			os;				// OS specific data.
	os_spinlock_t		spinlock;		// Control ISR access.
	os_sem_t			sem;			// Control thread access.
	gsc_dev_type_t		board_type;		// Corresponds to basic device type.
	const char*			model;			// Base model number in upper case.
	int					board_index;	// Index of the device being accessed.
	int					users;			// Number of currently active open() requests.
	int					share;			// Were we opened in shared mode?

	gsc_bar_t			bar;			// NOT USED BY THIS DRIVER!!!!!
};



#endif
