// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8112/driver/ioctl.c $
// $Rev: 47360 $
// $Date: 2020-06-02 12:14:02 -0500 (Tue, 02 Jun 2020) $

// PEX8112: Device Driver: source file

#include "main.h"



//*****************************************************************************
static int _query(dev_data_t* dev, s32* arg)
{
	switch (arg[0])
	{
		default:						arg[0]	= PEX8112_IOCTL_QUERY_ERROR;	break;
		case PEX8112_QUERY_COUNT:		arg[0]	= PEX8112_IOCTL_QUERY_LAST;		break;
		case PEX8112_QUERY_DEVICE_TYPE:	arg[0]	= dev->board_type;				break;
	}

	return(0);
}



// variables *******************************************************************

const gsc_ioctl_t	dev_ioctl_list[]	=
{
	{ PEX8112_IOCTL_REG_READ,	(void*) gsc_reg_read_ioctl	},
	{ PEX8112_IOCTL_REG_WRITE,	(void*) gsc_reg_write_ioctl	},
	{ PEX8112_IOCTL_REG_MOD,	(void*) gsc_reg_mod_ioctl	},
	{ PEX8112_IOCTL_QUERY,		(void*) _query				},

	{ -1, NULL }
};


