// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_reg_write.c $
// $Rev: 48774 $
// $Date: 2021-01-11 18:22:44 -0600 (Mon, 11 Jan 2021) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_reg_write
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_REG_WRITE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		This is the register to access.
*
*		set		This is the value to apply.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8111_reg_write(int fd, int index, int verbose, u32 reg, u32 set)
{
	gsc_reg_t	arg;
	int			errs	= 0;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Write", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= 0;	// unused here
	ret			= pex8111_ioctl(fd, PEX8111_IOCTL_REG_WRITE, &arg);
	errs		+= ret ? 1 : 0;

	if (verbose)
	{
		name	= gsc_reg_pex8111_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


