// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_reg_read.c $
// $Rev: 48774 $
// $Date: 2021-01-11 18:22:44 -0600 (Mon, 11 Jan 2021) $

// PEX8111: Utilities: source file

#include "main.h"



/*******************************************************************************
*
*	Function:	pex8111_reg_read
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_REG_READ service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		The register to access.
*
*		get		The value read goes here.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*******************************************************************************/

int pex8111_reg_read(int fd, int index, int verbose, u32 reg, u32* get)
{
	gsc_reg_t	arg;
	int			errs	= 0;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Read", index);

	arg.reg		= reg;
	arg.value	= 0xDEADBEEF;
	arg.mask	= 0;	// unused here
	ret			= pex8111_ioctl(fd, PEX8111_IOCTL_REG_READ, &arg);
	errs		+= ret ? 1 : 0;

	if (verbose)
	{
		name	= gsc_reg_pex8111_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	if (get)
		get[0]	= arg.value;

	return(errs);
}


