// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_query.c $
// $Rev: 48774 $
// $Date: 2021-01-11 18:22:44 -0600 (Mon, 11 Jan 2021) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_query
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_QUERY service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the query option to access.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8111_query(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	s32			query	= set;
	int			ret;

	switch (query)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Query Error (#%ld)", (long) query);
			break;

		case PEX8111_QUERY_COUNT:				ptr	= "Query Options";			break;
		case PEX8111_QUERY_DEVICE_TYPE:			ptr	= "Device Type";			break;
		case PEX8111_QUERY_PAYLOAD_SIZE_CAP:	ptr	= "Payload Size Capacity";	break;
	}

	if (verbose)
		gsc_label_index(ptr, index);

	ret		= pex8111_ioctl(fd, PEX8111_IOCTL_QUERY, &set);
	errs	+= ret ? 1 : 0;

	switch (query)
	{
		default:

			errs++;
			sprintf(buf, "%ld", (long) set);
			break;

		case PEX8111_QUERY_COUNT:

			sprintf(buf, "%ld", (long) set);
			break;

		case PEX8111_QUERY_PAYLOAD_SIZE_CAP:

			sprintf(buf, "%ld Bytes", (long) set);
			break;

		case PEX8111_QUERY_DEVICE_TYPE:

			if (set == GSC_DEV_TYPE_PEX8111)
			{
				strcpy(buf, "PEX8111");
			}
			else
			{
				errs++;
				sprintf(buf, "INVALID: %ld", (long) set);
			}

			break;
	}

	if (verbose)
	{
		if (errs)
			printf("FAIL <---  (%s)\n", buf);
		else
			printf("%s\n", buf);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


