// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_max_read_req_size.c $
// $Rev: 51700 $
// $Date: 2022-10-10 13:44:27 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_max_read_req_size
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_MAX_READ_REQ_SIZE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8111_max_read_req_size(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Max Read Request Size", index);

	ret		= pex8111_ioctl(fd, PEX8111_IOCTL_MAX_READ_REQ_SIZE, &set);
	errs	+= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case PEX8111_MAX_READ_REQ_SIZE_128:

			ptr	= "128 Bytes";
			break;

		case PEX8111_MAX_READ_REQ_SIZE_256:

			ptr	= "256 Bytes";
			break;

		case PEX8111_MAX_READ_REQ_SIZE_512:

			ptr	= "512 Bytes";
			break;

		case PEX8111_MAX_READ_REQ_SIZE_1024:

			ptr	= "1024 Bytes";
			break;

		case PEX8111_MAX_READ_REQ_SIZE_2048:

			ptr	= "2048 Bytes";
			break;

		case PEX8111_MAX_READ_REQ_SIZE_4096:

			ptr	= "4096 Bytes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


