// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_id.c $
// $Rev: 51700 $
// $Date: 2022-10-10 13:44:27 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: source file

#include "main.h"


/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		The handle used to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs	= 0;
	u32	reg;

	gsc_label("Vendor ID");
	errs	+= pex8111_reg_read(fd, -1, 0, GSC_PCI_8111_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= pex8111_reg_read(fd, -1, 0, GSC_PCI_8111_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x8111)
	{
		printf("(PEX8111)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	pex8111_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int pex8111_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs;
	const char*	psz			= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	= pex8111_query(fd, -1, 0, PEX8111_QUERY_DEVICE_TYPE, &device_type);

	if (errs)
	{
		if (verbose)
			printf("FAIL <---  (query error)\n");
	}
	else
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_PEX8111:	psz	= "PEX8111";	break;
		}

		if ((verbose) && (errs == 0))
			printf("%s\n", psz);

		gsc_label_level_inc();

		errs	+= _id_device_pci(fd);

		gsc_label_level_dec();
	}

	return(errs);
}



