// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_cache_line_size.c $
// $Rev: 51700 $
// $Date: 2022-10-10 13:44:27 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_cache_line_size
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_CACHE_LINE_SIZE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8111_cache_line_size(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs	= 0;
	int		ret;

	if (verbose)
		gsc_label_index("Cache Line Size", index);

	ret		= pex8111_ioctl(fd, PEX8111_IOCTL_CACHE_LINE_SIZE, &set);
	errs	+= ret ? 1 : 0;

	switch (set)
	{
		case 0x00:
		case 0x02:
		case 0x04:
		case 0x08:
		case 0x10:
		case 0x20:

			sprintf(buf,
					"0x%lX DWORDS/%ld Bytes",
					(long) set,
					(long) set * 4);
			break;

		default:

			sprintf(buf,
				"0x%lX DWORDS: NOT SUPPORTED, DEFAULTS TO 0",
					(long) set);
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


