// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/util_blind_prefetch.c $
// $Rev: 51700 $
// $Date: 2022-10-10 13:44:27 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_blind_prefetch
*
*	Purpose:
*
*		Provide a visual wrapper for the PEX8111_IOCTL_BLIND_PREFETCH service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int pex8111_blind_prefetch(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Blind Prefetch", index);

	ret		= pex8111_ioctl(fd, PEX8111_IOCTL_BLIND_PREFETCH, &set);
	errs	+= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case PEX8111_BLIND_PREFETCH_DISABLE:

			ptr	= "Disable";
			break;

		case PEX8111_BLIND_PREFETCH_ENABLE:

			ptr	= "Enable";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


