// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/read.c $
// $Rev: 51700 $
// $Date: 2022-10-10 13:44:27 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	pex8111_read_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device read call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		dst		The data read is placed here.
*
*		bytes	The volume of data to read.
*
*	Returned:
*
*		>= 0	The volume of data read.
*		< 0		The negative of the number of errors seen.
*
******************************************************************************/

int pex8111_read_util(int fd, int index, int verbose, void* dst, size_t bytes)
{
	int	ret;

	if (verbose)
		gsc_label_index("Reading", index);

	ret	= pex8111_read(fd, dst, bytes);

	if (verbose == 0)
	{
	}
	else if (ret >= 0)
	{
		printf("PASS  (%d Byte%s)\n", ret, (ret == 1) ? "" : "s");
	}
	else
	{
		printf(	"FAIL <---  (requested %ld Byte%s, ret = %ld)\n",
				(long) bytes,
				(bytes == 1) ? "" : "s",
				(long) ret);
	}

	return(ret);
}


