// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/open.c $
// $Rev: 48774 $
// $Date: 2021-01-11 18:22:44 -0600 (Mon, 11 Jan 2021) $

// PEX8111: Utilities: source file

#include "main.h"



/*****************************************************************************
*
*	Function:	pex8111_open_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device open call.
*
*	Arguments:
*
*		device	The zero based index of the device to access.
*
*		share	Open the device in shared access mode?
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		fd		The file descriptor is returned here.
*
*	Returned:
*
*		0		All went well. The fd value is valid.
*		> 0		The number of errors seen. The fd value is -1.
*
*****************************************************************************/

int pex8111_open_util(int device, int share, int index, int verbose, int* fd)
{
	int	errs	= 0;
	int	ret;

	if (verbose)
		gsc_label_index("Open", index);

	ret		= pex8111_open(device, share, fd);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (%s)\n",
				errs ? "FAIL <---" : "PASS",
				share ? "Shared" : "Exclusive");
	}

	return(errs);
}


