// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/utils/ioctl.c $
// $Rev: 46062 $
// $Date: 2019-08-13 15:34:53 -0500 (Tue, 13 Aug 2019) $

// PEX8111: Utilities: source file

#include "main.h"



/*****************************************************************************
*
*	Function:	pex8111_ioctl_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device IOCTL call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		request	The IOCTL service to request.
*
*		arg		The argument for the IOCTL service.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
*****************************************************************************/

int pex8111_ioctl_util(int fd, int index, int verbose, int request, void *arg)
{
	int	errs	= 0;
	int	ret;

	if (verbose)
		gsc_label_index("IOCTL", index);

	ret		= pex8111_ioctl(fd, request, arg);
	errs	+= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (#%d)\n",
				errs ? "FAIL <---" : "PASS",
				(int) OS_IOCTL_INDEX_DECODE(request));
	}

	return(errs);
}


