// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/samples/regs/perform.c $
// $Rev: 51707 $
// $Date: 2022-10-10 13:49:33 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _dump_everything(int fd)
{
	os_id_host();
	printf("\n");
	os_id_driver(pex8111_open, pex8111_read, pex8111_close);
	printf("\n");
	pex8111_id_device(fd, -1, 1);
	printf("\n");
	gsc_reg_pex8111_list_pci(fd, pex8111_reg_read);
	printf("\n");
	gsc_reg_pex8111_list_plx(fd, pex8111_reg_read);
}



//*****************************************************************************
static void _dump_pci(int fd)
{
	gsc_reg_pex8111_list_pci(fd, pex8111_reg_read);
}



//*****************************************************************************
static void _dump_plx(int fd)
{
	gsc_reg_pex8111_list_plx(fd, pex8111_reg_read);
}



//*****************************************************************************
static void _id_device(int fd)
{
	pex8111_id_device(fd, -1, 1);
}



//*****************************************************************************
static void _id_driver(int fd)
{
	os_id_driver(pex8111_open, pex8111_read, pex8111_close);
}



//*****************************************************************************
static void _id_host(int fd)
{
	os_id_host();
}



//****************************************************************************
int perform_tests(int fd)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Device Identification",			_id_device			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(fd, &menu);
	return(0);
}



