// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/samples/regs/main.c $
// $Rev: 48782 $
// $Date: 2021-01-12 10:11:55 -0600 (Tue, 12 Jan 2021) $

// PEX8111: Sample Application: source file

#include "main.h"



// variables ******************************************************************

static	s32	_def_index	= 0;



//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	static const gsc_arg_item_t	list[]	=
	{
		//	type				var				arg			values	desc
		{	GSC_ARG_DEV_INDEX,	&_def_index,	"index",	{ 1 },	"The zero based index of the device to access."	}
	};

	static const gsc_arg_set_t	set	=
	{
		/* name	*/	"regs",
		/* desc	*/	"Register Access Application",
		/* qty	*/	SIZEOF_ARRAY(list),
		/* list	*/	list
	};

	int	errs;

	errs	= gsc_args_parse(argc, argv, &set);

	return(errs);
}



//*****************************************************************************
static void _show_access_index(int index)
{
	gsc_label("Accessing Device");
	printf("%d\n", index);
}



//*****************************************************************************
static void _show_time_stamp(void)
{
	const char*	psz;
	struct tm*	stm;
	time_t		tt;

	time(&tt);
	stm	= localtime(&tt);
	psz	= (char*) asctime(stm);
	gsc_label("Time Stamp");
	printf("%s", psz);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall flow of the application.
*
*	Arguments:
*
*		argc			The number of command line arguments.
*
*		argv			The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more problems were encounterred.
*
******************************************************************************/

int main(int argc, char** argv)
{
	int		errs		= 0;
	time_t	exec		= time(NULL);
	long	failures	= 0;
	int		fd			= 0;
	long	hours;
	long	mins;
	time_t	now;
	long	passes		= 0;
	int		qty			= 0;
	int		ret;
	long	secs;
	long	tests		= 0;

	for (;;)
	{
		gsc_label_init(28);
		errs	= _parse_args(argc, argv);

		if (errs == 0)
		{
			// Introduction

			os_id_host();
			_show_time_stamp();
			_show_access_index(_def_index);
			errs	+= pex8111_init_util(1);
			errs	+= os_id_driver(pex8111_open, pex8111_read, pex8111_close);
			errs	+= pex8111_count_boards(1, &qty);

			if (qty <= 0)
				errs	= errs ? errs : 1;
		}

		// Open access to device

		if (errs == 0)
			errs	= pex8111_open_util(_def_index, 0, -1, 1, &fd);

		if (errs == 0)
		{
			// Device identification

			errs	= pex8111_id_device(fd, -1, 1);

			// Perform testing

			errs	+= perform_tests(fd);

			// Close device access

			errs	+= pex8111_close_util(fd, -1, 1);
		}

		// End of processing.

		now	= time(NULL);
		tests++;

		if (errs)
		{
			failures++;
			printf(	"\nRESULTS: FAIL <---\n");
		}
		else
		{
			passes++;
			printf("\nRESULTS: PASS\n");
		}

		secs	= (long) (now - exec);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(	"SUMMARY: tests %ld, pass %ld, fail %ld"
				" (duration %ld:%ld:%02ld)\n\n",
				tests,
				passes,
				failures,
				hours,
				mins,
				secs);
		break;
	}

	ret	= ((qty <= 0) || (errs) || (failures)) ? EXIT_FAILURE : EXIT_SUCCESS;
	return(ret);
}



