// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/samples/prefetch/main.h $
// $Rev: 51706 $
// $Date: 2022-10-10 13:49:17 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "pex8111_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)						(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Program Settings
	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	device_qty;
	s32	index;			// device index
	s32	minute_limit;
	s32	test_limit;

	int	fd;

	// Device Settings

	s32	blind_prefetch;
	s32	cache_line_size;
	s32	flow_control_credit;
	s32	payload_size_max;
	s32	prefetch_size;
	s32	read_req_size_max;
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
