// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/samples/payload/perform.c $
// $Rev: 51705 $
// $Date: 2022-10-10 13:49:02 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Sample Application: source file

#include "main.h"



//*****************************************************************************
static int _pex8111_enum(const args_t* args)
{
	char		buf[128];
	int			errs		= 0;
	int			fd			= 0;
	int			i;
	u32			mbr;
	u32			mlr;
	gsc_reg_t	reg;
	int			ret;

	for (i = 0; i < args->device_qty; i++)
	{
		sprintf(buf, "%s %d", PEX8111_BASE_NAME, i);
		gsc_label(buf);
		ret	= pex8111_open_util(i, 1, -1, 0, &fd);

		if (ret)
		{
			printf("SKIPPED  (Can't access device.)\n");
			continue;
		}

		// Read the memory mapping registers.
		memset(&reg, 0, sizeof(reg));
		reg.reg	= GSC_PCI_8111_MBR;
		ret		= pex8111_ioctl(fd, PEX8111_IOCTL_REG_READ, &reg);
		errs	+= ret ? 1 : 0;
		mbr		= reg.value;

		memset(&reg, 0, sizeof(reg));
		reg.reg	= GSC_PCI_8111_MLR;
		ret		= pex8111_ioctl(fd, PEX8111_IOCTL_REG_READ, &reg);
		errs	+= ret ? 1 : 0;
		mlr		= reg.value;

		if (errs == 0)
		{
			mbr	= (mbr >> 4);
			mbr	= (mbr << 20);
			mlr	= (mlr >> 4);
			mlr	= (mlr << 20) | 0xFFFFF;
			printf("PASS  (0x%lX - 0x%lX)\n", (long) mbr, (long) mlr);
		}

		close(fd);
	}

	return(errs);
}



//*****************************************************************************
static int _payload_size_cap(int fd)
{
	s32	ans;
	int	errs;

	gsc_label("Payload Size Capability");
	errs	= pex8111_query(fd, -1, 0, PEX8111_QUERY_PAYLOAD_SIZE_CAP, &ans);

	if (errs)
	{
	}
	else if (ans > 1)
	{
		printf("%ld Bytes\n", (long) ans);
	}
	else if (ans == 1)
	{
		printf("%ld Byte\n", (long) ans);
	}
	else if (ans < 0)
	{
		printf("UNKNOWN\n");
	}
	else
	{
		errs++;
		printf("FAIL <--  (Unrecognized value: %ld)\n", (long) ans);
	}

	return(errs);
}



//*****************************************************************************
static int _pex8111_config(const args_t* args)
{
	int	errs	= 0;

	errs	+= _payload_size_cap(args->fd);
	errs	+= pex8111_payload_size_max(args->fd, -1, 1, args->pl_size_max, NULL);

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs;

	errs	= _pex8111_enum(args);

	if (errs == 0)
		errs	= _pex8111_config(args);

	return(errs);
}



