// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/samples/id/perform.c $
// $Rev: 51704 $
// $Date: 2022-10-10 13:48:26 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	errs	+= pex8111_cache_line_size		(args->fd, -1, 1, -1, NULL);
	errs	+= pex8111_blind_prefetch		(args->fd, -1, 1, -1, NULL);
	errs	+= pex8111_prefetch_size		(args->fd, -1, 1, -1, NULL);
	errs	+= pex8111_comp_flow_ctl_crdt	(args->fd, -1, 1, -1, NULL);
	errs	+= pex8111_max_read_req_size	(args->fd, -1, 1, -1, NULL);
	errs	+= pex8111_payload_size_max		(args->fd, -1, 1, -1, NULL);

	for (i = 0; i < PEX8111_IOCTL_QUERY_LAST; i++)
		errs	+= pex8111_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();
	return(errs);
}


