// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/include/pex8111_utils.h $
// $Rev: 51708 $
// $Date: 2022-10-10 13:50:33 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Utilities: header file

#ifndef	__PEX8111_UTILS_H__
#define	__PEX8111_UTILS_H__

#include "pex8111_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	pex8111_close_util			(int fd, int index, int verbose);
int pex8111_init_util			(int verbose);
int pex8111_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	pex8111_open_util			(int device, int share, int index, int verbose, int* fd);
int pex8111_read_util			(int fd, int index, int verbose, void* dst, size_t bytes);

// IOCTL utility services

int	pex8111_blind_prefetch		(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_BLIND_PREFETCH
int	pex8111_cache_line_size		(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_CACHE_LINE_SIZE
int	pex8111_comp_flow_ctl_crdt	(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_COMP_FLOW_CTL_CRDT
int	pex8111_max_read_req_size	(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_MAX_READ_REQ_SIZE
int	pex8111_payload_size_max	(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_PAYLOAD_SIZE_MAX
int	pex8111_prefetch_size		(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_PREFETCH_SIZE
int	pex8111_query				(int fd, int index, int verbose, s32 set, s32* get);			// PEX8111_IOCTL_QUERY
int pex8111_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// PEX8111_IOCTL_REG_MOD
int	pex8111_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// PEX8111_IOCTL_REG_READ
int	pex8111_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// PEX8111_IOCTL_REG_WRITE

// Auxiliary utility services

int pex8111_id_device			(int fd, int index, int verbose);

int	pex8111_count_boards		(int verbose, s32* get);



#endif
