// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/driver/pex8111.h $
// $Rev: 51709 $
// $Date: 2022-10-10 13:56:06 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Device Driver: header file

#ifndef	__PEX8111_H__
#define	__PEX8111_H__

#include "gsc_common.h"
#include "gsc_pex8111.h"



// macros *********************************************************************

#define	PEX8111_BASE_NAME					"pex8111"

// IOCTL command codes
#define	PEX8111_IOCTL_REG_READ				OS_IOCTL_RW(0, 12, gsc_reg_t)
#define	PEX8111_IOCTL_REG_WRITE				OS_IOCTL_W (1, 12, gsc_reg_t)
#define	PEX8111_IOCTL_REG_MOD				OS_IOCTL_W (2, 12, gsc_reg_t)
#define	PEX8111_IOCTL_QUERY					OS_IOCTL_RW(3,  4, s32)
#define	PEX8111_IOCTL_BLIND_PREFETCH		OS_IOCTL_RW(4,  4, s32)
#define	PEX8111_IOCTL_PREFETCH_SIZE			OS_IOCTL_RW(5,  4, s32)
#define	PEX8111_IOCTL_COMP_FLOW_CTL_CRDT	OS_IOCTL_RW(6,  4, s32)
#define	PEX8111_IOCTL_CACHE_LINE_SIZE		OS_IOCTL_RW(7,  4, s32)
#define	PEX8111_IOCTL_PAYLOAD_SIZE_MAX		OS_IOCTL_RW(8,  4, s32)
#define	PEX8111_IOCTL_MAX_READ_REQ_SIZE		OS_IOCTL_RW(9,  4, s32)


//*****************************************************************************
// PEX8111_IOCTL_REG_READ
// PEX8111_IOCTL_REG_WRITE
// PEX8111_IOCTL_REG_MOD
//
// Parameter:	gsc_reg_t*

//*****************************************************************************
// PEX8111_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	PEX8111_QUERY_COUNT,					// How many query options are supported?
	PEX8111_QUERY_DEVICE_TYPE,				// Value from gsc_dev_type_t
	PEX8111_QUERY_PAYLOAD_SIZE_CAP,			// The device's capability.
	PEX8111_IOCTL_QUERY_LAST

} pex8111_query_t;

#define	PEX8111_IOCTL_QUERY_ERROR			(-1)

//*****************************************************************************
// PEX8111_IOCTL_BLIND_PREFETCH				DSCR D0
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_BLIND_PREFETCH_DISABLE		0
#define	PEX8111_BLIND_PREFETCH_ENABLE		1

//*****************************************************************************
// PEX8111_IOCTL_PREFETCH_SIZE				PCR D27-D29
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_PREFETCH_SIZE_CL			0	// Follow Cache Line limitations
#define	PEX8111_PREFETCH_SIZE_64			1
#define	PEX8111_PREFETCH_SIZE_128			2
#define	PEX8111_PREFETCH_SIZE_256			3
#define	PEX8111_PREFETCH_SIZE_512			4
#define	PEX8111_PREFETCH_SIZE_1024			5
#define	PEX8111_PREFETCH_SIZE_2048			6
#define	PEX8111_PREFETCH_SIZE_4096			7

//*****************************************************************************
// PEX8111_IOCTL_COMP_FLOW_CTL_CRDT			TCC0R D22
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_COMP_FLOW_CTL_CRDT_NO		0
#define	PEX8111_COMP_FLOW_CTL_CRDT_YES		1

//*****************************************************************************
// PEX8111_IOCTL_CACHE_LINE_SIZE			CLSR D0-D7
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_CACHE_LINE_SIZE_0			0x00
#define	PEX8111_CACHE_LINE_SIZE_8			0x02
#define	PEX8111_CACHE_LINE_SIZE_16			0x04
#define	PEX8111_CACHE_LINE_SIZE_32			0x08
#define	PEX8111_CACHE_LINE_SIZE_64			0x10
#define	PEX8111_CACHE_LINE_SIZE_128			0x20

//*****************************************************************************
// PEX8111_IOCTL_PAYLOAD_SIZE_MAX			PEDCR D5-D7
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_PAYLOAD_SIZE_MAX_128		0
#define	PEX8111_PAYLOAD_SIZE_MAX_256		1
#define	PEX8111_PAYLOAD_SIZE_MAX_512		2
#define	PEX8111_PAYLOAD_SIZE_MAX_1024		3
#define	PEX8111_PAYLOAD_SIZE_MAX_2048		4
#define	PEX8111_PAYLOAD_SIZE_MAX_4096		5

//*****************************************************************************
// PEX8111_IOCTL_MAX_READ_REQ_SIZE			PEDCR D12-D14
//
//	Parameter:	s32*
//		Valid values are any of the below,
//		or -1 to retrieve the current setting.
#define	PEX8111_MAX_READ_REQ_SIZE_128		0
#define	PEX8111_MAX_READ_REQ_SIZE_256		1
#define	PEX8111_MAX_READ_REQ_SIZE_512		2
#define	PEX8111_MAX_READ_REQ_SIZE_1024		3
#define	PEX8111_MAX_READ_REQ_SIZE_2048		4
#define	PEX8111_MAX_READ_REQ_SIZE_4096		5



#endif
