// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/PEX8111/PEX8111_Linux_1.x.x.x_GSC_DN/driver/main.h $
// $Rev: 51709 $
// $Date: 2022-10-10 13:56:06 -0500 (Mon, 10 Oct 2022) $

// PEX8111: Device Driver: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include "pex8111.h"

#define	DEV_BAR_SHOW						0
#define	DEV_PCI_ID_SHOW						0
#define	GSC_ALT_DEV_GET(a)					(a)
#define	GSC_ALT_STRUCT_GET(i,d)				(d)
#define	GSC_ALT_STRUCT_T					dev_data_t
#define	GSC_DEVS_PER_BOARD					1
typedef struct _dev_data_t					dev_data_t;

#include "gsc_main.h"



// macros *********************************************************************

#define	DEV_MODEL							"PEX8111"	// Upper case form of the below.
#define	DEV_NAME							"pex8111"	// MUST AGREE WITH PEX8111_BASE_NAME

#define	DEV_VERSION							"2.2"		// FOR DEVICE SPECIFIC CODE ONLY!
// 2.2	Removed compiler warning for Fedora Fedora 35.
//		White space cleanup.
//		Improved driver start script.
//		Updated per changes to directory organization.
//		Updated comments for consistency.
// 2.1	Added support for the 5.x kernel series.
//		Added Endianness support.
//		Removed compiler warnings for Fedora 31.
//		Updated initial file content for consistency.
//		White space cleanup.
//		Renumbered the QUERY options.
//		Updated per changes to the low level register interface.
//		Updated per changes to the OS specific PCI services.
//		Made updates for DEV_SUPPORTS_XXX macro changes.
// 2.0	Updated to use the newer common driver sources.
//		Removed GNU notice from non-Linux specific files.
//		Removed Linux specific content from non-Linux specific source files.
//		White space cleanup.
//		Now using a spinlock rather than enabling and disabling interrupts.
//		Made PCI registers accessible from inside an ISR.
//		The BAR code has been updated to include the data under a single structure.
//		The register definitions have been updated.
//		I/O services now pass around an os_mem_t structure instead of a buffer pointer.
//		White space cleanup.
//		Changed the arbitrary wait event callback argument to a void* type.
//		Modified to allow multiple apps to simultaneously access a single device.
//		Corrected the IOCTL code for the register write and mod services.
// 1.7	Reduced #include list in driver interface header.
// 1.6	Added PEX8111_IOCTL_MAX_READ_REQ_SIZE.
//		Renamed PEX8111_IOCTL_PREFETCH_ENABLE to PEX8111_IOCTL_BLIND_PREFETCH.
//		Removed PEX8111_QUERY_PREFETCH_SIZE_LIM.
// 1.5	Added IOCTL service PEX8111_IOCTL_PAYLOAD_SIZE_MAX.
// 1.4	Corrected a bug in the Prefetch Enable service.
// 1.3	Updated for the 3.x kernel.
// 1.2	Include all common source, though not all are used.
// 1.1	Added Payload Size query options.
//		Added Prefetch control options.
// 1.0	Initial release.

#define	GSC_PCI_SPACE_SIZE					0xFFF



// data types *****************************************************************

struct _dev_data_t
{
	os_pci_t			pci;			// The kernel PCI device descriptor.
	os_data_t			os;				// OS specific data.
	os_spinlock_t		spinlock;		// Control ISR access.
	os_sem_t			sem;			// Control thread access.
	gsc_dev_type_t		board_type;		// Corresponds to basic device type.
	const char*			model;			// Base model number in upper case.
	int					board_index;	// Index of the device being accessed.
	int					users;			// Number of currently active open() requests.
	int					share;			// Were we opened in shared mode?

	gsc_bar_t			bar;			// NOT USED BY THIS DRIVER!!!!!
};



// prototypes *****************************************************************

int	dev_reg_mod_pci(GSC_ALT_STRUCT_T* alt, gsc_reg_t* arg);



#endif
